/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.impl;

import com.cisco.pt.ptmp.PacketTracerConnection;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class LowLevelReadThread
extends Thread {
    protected BlockingQueue<ByteBuffer> messageList;
    protected PacketTracerConnection connection;
    protected volatile boolean shouldStop = false;
    protected boolean useBinaryEncoding = false;
    protected ByteBuffer inputBuffer;
    protected byte[] rawBuffer;
    protected int writePosition;

    public LowLevelReadThread(PacketTracerConnection connection) {
        this.connection = connection;
        this.useBinaryEncoding = connection.connectionNegotiationProperties().isBinaryEncoding();
        this.messageList = new LinkedBlockingQueue<ByteBuffer>();
    }

    public ByteBuffer getNextMessage() throws InterruptedException {
        return this.messageList.take();
    }

    public void shouldStop() {
        this.shouldStop = true;
        this.interrupt();
    }

    public void run() {
        this.inputBuffer = ByteBuffer.allocate(100000);
        this.initializeRawBuffer();
        while (!this.shouldStop) {
            try {
                while (!this.hasCompleteLengthField()) {
                    this.readIntoRawBuffer();
                }
                int messageLength = this.extractLengthField();
                this.grow(messageLength + 20);
                while (this.getReadSize() < messageLength) {
                    this.readIntoRawBuffer();
                }
                byte[] messageRawData = this.extract(messageLength);
                ByteBuffer messageBuffer = ByteBuffer.wrap(messageRawData);
                this.messageList.put(messageBuffer);
            }
            catch (InterruptedException e) {
                this.shouldStop = true;
            }
            catch (ClosedByInterruptException e) {
                this.shouldStop = true;
            }
            catch (Throwable t) {
                this.connection.noteLowLevelReadError(t);
            }
        }
    }

    protected int readIntoRawBuffer() throws Exception {
        int numberRead = this.connection.read(this.inputBuffer);
        if (numberRead > 0) {
            if (numberRead > this.getWriteSize()) {
                this.growBy(numberRead - this.getWriteSize());
            }
            this.inputBuffer.flip();
            this.inputBuffer.get(this.rawBuffer, this.writePosition, numberRead);
            this.writePosition += numberRead;
            this.inputBuffer.clear();
        } else if (numberRead == -24 || numberRead < 0) {
            throw new Exception("Bad read of message from PacketTracer");
        }
        return numberRead;
    }

    protected void initializeRawBuffer() {
        this.rawBuffer = new byte[20000];
        this.writePosition = 0;
    }

    protected boolean hasCompleteLengthField() {
        if (this.useBinaryEncoding) {
            return this.getReadSize() >= 4;
        }
        return this.getFirstTextDelimiterIndex() >= 0;
    }

    protected int getFirstTextDelimiterIndex() {
        for (int i = 0; i < this.writePosition; ++i) {
            if (this.rawBuffer[i] != 0) continue;
            return i;
        }
        return -1;
    }

    protected int extractLengthField() {
        if (this.useBinaryEncoding) {
            byte[] data = this.extract(4);
            return ByteBuffer.wrap(data).getInt();
        }
        byte[] data = this.extract(this.getFirstTextDelimiterIndex());
        this.extract(1);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            builder.append((char)data[i]);
        }
        return Integer.parseInt(builder.toString());
    }

    protected byte[] extract(int length) {
        int i;
        byte[] answer = new byte[length];
        for (i = 0; i < length; ++i) {
            answer[i] = this.rawBuffer[i];
        }
        for (i = length; i < this.writePosition; ++i) {
            this.rawBuffer[i - length] = this.rawBuffer[i];
        }
        this.writePosition -= length;
        return answer;
    }

    protected int getReadSize() {
        return this.writePosition;
    }

    protected int getWriteSize() {
        return this.rawBuffer.length - this.writePosition;
    }

    protected void growBy(int lengthIncrease) {
        this.grow(this.rawBuffer.length + lengthIncrease);
    }

    protected void grow(int length) {
        if (this.rawBuffer.length >= length) {
            return;
        }
        int minimumNewLength = (int)Math.round(1.5 * (double)this.rawBuffer.length);
        int newLength = Math.max(length, minimumNewLength);
        byte[] newBuffer = new byte[newLength];
        for (int i = 0; i < this.writePosition; ++i) {
            newBuffer[i] = this.rawBuffer[i];
        }
        this.rawBuffer = newBuffer;
    }

    protected void show(String name, byte[] buffer, int limit) {
        int i;
        System.out.println("Buffer " + name + ", limit = " + limit + ", length = " + buffer.length);
        System.out.print("\t");
        for (i = 0; i < limit; ++i) {
            System.out.print(buffer[i]);
            System.out.print(", ");
        }
        System.out.println();
        for (i = 0; i < limit; ++i) {
            int ch = (char)(buffer[i] == 0 ? 95 : (char)buffer[i]);
        }
        System.out.println();
    }
}

